---
Note type: Project
tags:
  - "#project"
Project status: Ongoing
Project type: Service
Start date: 2024-04-17
Next deadline: 2024-04-17
Related areas:
  - "[[Academic service]]"
  - "[[Teaching]]"
Related projects: 
Related tasks:
  - "[[Develop proposal for new elective course]]"
  - "[[Review assessment plan for SOC301]]"
Related people:
  - "[[Emily Johnson]]"
  - "[[James Wilson]]"
Related resources:
  - "[[Curriculum Committee Meeting - 12 April 2024]]"
  - "[[Sociology Department Curriculum Review Report]]"
Related references: 
Related zettels: 
aliases: 
Title: Curriculum Committee
Creation date: 2024-04-17
Last modified: 2024-04-17
---

## Fleeting notes

### 2023-09-20
Student exit survey and alumni feedback both point to desire for more hands-on research experience. Consider a required capstone project or expanding assistantship opportunities? May need to reallocate some faculty lines or build more external partnerships.

### 2024-02-20
Lots of student interest in new Sociology of Tech course. Consider developing into a permanent elective or even a certificate. Reach out to CS and Info Sci about potential partnerships.

### 2024-03-10
Promising initial data on student learning outcomes for new social problems course piloted this year. Seems to be hitting the mark for engagement with current events and policy implications. Should we move to make it a permanent elective? What else might we retire to make space?

## General notes

3-year term on the department's Undergraduate Curriculum Committee - charged with conducting regular assessment of our major/minor requirements, reviewing proposals for new courses, and suggesting changes to enhance student learning and experience.

### Key responsibilities
- Organize and interpret data from student evaluations, exit surveys, and alumni outreach
- Review syllabi and assignments for alignment with learning objectives
- Consult with Assessment Office and other support units on best practices
- Facilitate curriculum discussions at department meetings and retreats
- Provide feedback and guidance to faculty on course design
- Evaluate proposals for new courses and revisions to requirements
- Coordinate with other departments and colleges on shared offerings and requirements
- Maintain curriculum documents and handbooks
- Communicate policies and changes to students and advisors
### Primary goals
- Conduct comprehensive review of curriculum
	- Map current courses to learning outcomes
	- Identify strengths, gaps, and redundancies
	- Integrate student feedback and assessment data
	- Develop recommendations for revisions and updates
- Propose and approve new courses
	- Review proposals for fit and quality
	- Offer feedback and suggested revisions
	- Shepherd through college and university approval process
	- Oversee roll-out and assessment
- Serve as liaison to other department committees
	- Share data and recommendations with assessment committee
	- Coordinate with scheduling and staffing leads
	- Communicate policies and changes to advisors and students
	- Collaborate with graduate committee on TA training and mentoring
- Ensure alignment with disciplinary standards and trends
	- Review peer program curricula and requirements
	- Attend teaching sessions at major conferences
	- Consult ASA recommended practices and resources
- Support ongoing course improvement and innovation
	- Organize teaching workshops and faculty learning communities
	- Offer small grants for course development and enhancement
	- Recognize effective teaching through annual awards
	- Promote SoTL research and publication

### Key initiatives
- 5-year curriculum review and revision
- New elective on social movements and activism
- Extended research methods sequence and capstone
- Streamlined process for study abroad and internship credit
- Sociology and computation certificate
- Anti-racist pedagogy faculty development series

### Challenges and support needs
- Curricula can be slow to change and reflect latest developments
- Balancing desire for innovation with constraints on faculty/dept resources
- Navigating different views on what is core to the discipline
- Getting meaningful student input and data to inform decisions
- Translating high-level goals into concrete course and assignment designs

### Action timeline
- Analyze results of curriculum mapping exercise (May 2024)
- Draft proposed revisions to major and minor requirements (Aug 2024)
- Review assessment report for capstone seminar (Oct 2024)
- Solicit proposals for new electives to round out offerings (Nov 2024)
- Update advising materials and website with any changes (Jan 2025)
- Plan professional development for faculty on inclusive pedagogy (Mar 2025)
- Conduct focus groups with current students for input (Apr 2025)

## Actionables

> [!area] Areas
> ```dataview
TABLE without id row.file.link as Areas
FROM "Actionables/Areas"
WHERE contains(related-areas, [[]])
SORT file.ctime DESC
LIMIT 50
> ```

> [!project] Projects
> ```dataview
TABLE without id row.file.link as Projects
FROM "Actionables/Projects"
WHERE contains(related-areas, [[]])
SORT file.ctime DESC
LIMIT 50
> ```

> [!task]+ Tasks
>  ```dataview
>TABLE without id row.file.link as Task, join(related-projects) as Project, join(do-date) as "Do Date", join(due-date) as "Due Date", join(task-size) as "Task Size", join(priority) as "Task Priority", 
>choice(done, "✅",":LiBoxSelect:") as Done, 
>choice(waiting-on-someone, "✅",":LiBoxSelect:") as "Waiting on Someone",
>choice(task-amnesty, "✅",":LiBoxSelect:") as "Task Amnesty" 
>FROM "Actionables/Tasks"
>WHERE contains(related-areas, [[]])
>SORT done ASC, task-amnesty ASC, waiting-on-someone ASC, choice(!do-date, date(2100-01-01), do-date) ASC, task-type DESC, choice(priority = "⚫ TBD", "1", choice(priority = "🔴 A", "2", choice(priority = "🟡 B", "3", choice(priority = "🟢 C", "4", choice(priority = "🟣 D", "5", choice(priority = "🔵 E", "6", "other")))))), choice(task-size = "🎂 Big", "1", choice(task-size = "🍰 Medium", "2", choice(task-size = "🧁 Small", "3", "other"))), priority ASC, choice(!due-date, date(2100-01-01), due-date) ASC, related-areas ASC, related-projects ASC
> ``` 
## Knowledge management system

> [!moc]- Maps of Content
> ```dataview
TABLE without id row.file.link as MoCs
FROM "Knowledge management system/Maps of Content"
WHERE contains(related-areas, [[]])
SORT file.ctime DESC
LIMIT 50
> ```

> [!reference]- References
> ```dataview
TABLE without id row.file.link as References
FROM "Knowledge management system/References"
WHERE contains(related-areas, [[]])
SORT file.ctime DESC
LIMIT 50
> ```

> [!zettel]- Zettelkasten
> ```dataview
TABLE without id row.file.link as Zettels
FROM "Knowledge management system/Zettelkasten"
WHERE contains(related-areas, [[]])
SORT file.ctime DESC
LIMIT 50
> ```

## Project management system

> [!meeting]- Meeting notes
> ```dataview
TABLE without id row.file.link as "Meeting Notes"
FROM "Project management system/Meeting notes"
WHERE contains(related-areas, [[]])
SORT file.ctime DESC
LIMIT 50
> ```

> [!resource]- Resources
> ```dataview
TABLE without id row.file.link as Resources
FROM "Project management system/Resources"
WHERE contains(related-areas, [[]])
SORT file.ctime DESC
LIMIT 50
> ```

> [!person]- Rolodex
> ```dataview
TABLE without id row.file.link as People
FROM "Project management system/Rolodex"
WHERE contains(related-areas, [[]])
SORT file.ctime DESC
LIMIT 50
> ```

